// Tiles.js by Radnen.

//  Last Updated  //
// -- 03/12/10 -- //

var Tiles = 0;
var MovedByMouse = false;
//------ LEAVE TILE ------//
function On_Leave()
{
	TeleportMe = true;
	if (!MovedByMouse) Mouse.idle = true;
	MovedByMouse = false;
	var X = GetPersonX(Player.name);
	var Y = GetPersonY(Player.name);

	if (TileName(1) == "tile") {
		SetTile(X/32, Y/32, 1, 0);
		Tiles--;
		if (Player.health < Player.maxhealth) Player.health++;
		CreateTileAnim(X, Y);
	}

	if (TileName(1) == "tile2") {
		SetTile(X/32, Y/32, 1, 3);
	}

	if (TileName(1) == "tile3") {
		SetTile(X/32, Y/32, 1, 4);
	}
}

//------ ON TILE ------//
function On_Tile()
{
	UpdateTraps();
}

function CheckAroundPlayer() // will check to see if your're closed in or not.
{ // fixed so it doesn't check diagonals. Because you can't travel diagonally.
	var X = GetPersonX(Player.name) / 32;
	var Y = GetPersonY(Player.name) / 32;
	var NearTiles = 0;

	for (var h = 0; h < 6; ++h) {
		if (Y-3+h >= 0 && Y-3+h <= 15) {
			var tile = GetTile(X, Y-3+h, 1); var tile2 = GetTile(X, Y-3+h, 0);
			var name1 = GetTileName(tile); var name2 = GetTileName(tile2);
			if (name1 == "tile"  || name2 == "tile")  NearTiles++;
			if (name1 == "tile2" || name2 == "tile2") NearTiles++;
			if (name1 == "tile3" || name2 == "tile3") NearTiles++; 
			if (name1 == "start" || name2 == "start") NearTiles++; 
			if (name1 == "Other" || name2 == "Other") NearTiles++;
		}
	}

	for (var w = 0; w < 6; ++w) {
		if ((X-3)+w >= 0 && (X-3)+w <= 20) {
			var tile = GetTile(X-3+w, Y, 1); var tile2 = GetTile(X-3+w, Y, 0);
			var name1 = GetTileName(tile); var name2 = GetTileName(tile2);
			if (name1 == "tile"  || name2 == "tile")  NearTiles++;
			if (name1 == "tile2" || name2 == "tile2") NearTiles++;
			if (name1 == "tile3" || name2 == "tile3") NearTiles++; 
			if (name1 == "start" || name2 == "start") NearTiles++; 
			if (name1 == "Other" || name2 == "Other") NearTiles++;
		}
	}

	if (NearTiles >= 3) return true;
	return false;	
}

//------ ENTER TILE ------//
function On_Enter()
{
	if (Tiles == 0 && TileName(1) == "start") {
		TextWindow(3, 3, SW-6, 24, "You won! :)");
		NextLevel();
	}

	if (TileName(0) == "death" && TileName(1) == "") PlayerDie();

	if (TileName(1) == "tile" || TileName(1) == "Other" && !TeleportMe || TileName(1) == "start" && Tiles > 0) {
		if (!CheckAroundPlayer()) {
			TextWindow(3, 3, SW-6, 24, "You trapped yourself!");
			RestartMenu();
		}
	}

	if(Player.jumping) {
		SetPersonSpeed(Player.name, 2);
		Player.jumping = false;
	}
}

function TileName(l)
{
	var X = (Player.x-8)/32;
	var Y = (Player.y-8)/32;
	var LW = GetLayerWidth(0);
	var LH = GetLayerHeight(0);

	if(X > 0 && Y > 0 && X < LW && Y < LH) {
		var tile = GetTile(X, Y, l);
		return GetTileName(tile);
	}
	else return "death"; // you'll die if a tile can't be found within the border.
}

function CountTiles()
{
	var LH = GetLayerHeight(0)
	var LW = GetLayerWidth(0);
	Tiles = 0;
	for(var y = 0; y < LH; ++y) {
		for(var x = 0; x < LW; ++x) {
			var tile = GetTile(x, y, 1)
			var name = GetTileName(tile);
			
			if (name == "tile") Tiles++;
			if (name == "tile2") Tiles++;
			if (name == "tile3") Tiles++;
		}
	}
}

//------ TILE ANIMATION!! ------//

var TileAnims = [];
var TileAnim = 0;

function TileAnimation(name, x, y)
{
	this.x = x; this.y = y;
	this.name = name;
}

function CreateTileAnim(x, y)
{
	TileAnims[TileAnim] = new TileAnimation("Tile" + TileAnim, x, y);
	with(TileAnims[TileAnim]) {
		CreatePerson(name, TileType, true);
		SetPersonXYFloat(name, x, y);
		SetPersonDirection(name, "Break");
		SetPersonLayer(name, 0);
		for (var i = 0; i < 47; ++i) QueuePersonCommand(name, COMMAND_ANIMATE, false);
		SetPersonScript(name, SCRIPT_COMMAND_GENERATOR, 'WaitForDestroy()');
	}
	TileAnim++;
}

function WaitForDestroy()
{
	var p = GetCurrentPerson();
	if (IsCommandQueueEmpty(p)) {
		SetTile(GetPersonX(p)/32, GetPersonY(p)/32, 1, 0);
		DestroyPerson(p);
	}
}

function PlayerDie()
{
	TileMovement.pauseEngine();
	TileMovement.stopEngine(true);
	Player.dead = true;
	SetPersonDirection(Player.name, "death");
	for (var i = 0; i < 16; ++i) QueuePersonCommand(Player.name,COMMAND_ANIMATE,false);
	SetPersonScript(Player.name, SCRIPT_COMMAND_GENERATOR, 'WaitForDeath()');
}

function WaitForDeath()
{
	var name = GetCurrentPerson();
	if (IsCommandQueueEmpty(name)) Player.death = true;
}

//------ TILE TELEPORT ------//
var TeleportMe = true;
function Teleport(x,y)
{
	if (TeleportMe) {
		var Name = Player.name;
		WaitForPerson(Name);
		TileMovement.pauseEngine();
		TileMovement.stopEngine();
		var nx = x*32+15, ny = y*32+15;
		CreatePerson("t","Teleport.rss",true);
		SetPersonXYFloat("t",GetPersonX("b"),GetPersonY("b"));
		SetPersonDirection(Name,"TeleportOut");
		SetPersonFrame(Name,0);
		
		for(var i = 0; i < 15; ++i) {
			QueuePersonCommand(Name,COMMAND_ANIMATE,false);
			QueuePersonCommand("t",COMMAND_ANIMATE,false);
		}
		
		WaitForPerson(Name);
		DestroyPerson("t");
		CreatePerson("t", "Teleport.rss", true);
		SetPersonXYFloat("t", nx, ny);
		SetPersonXYFloat(Name, nx, ny);
		SetPersonDirection(Name, "TeleportIn");
		SetPersonFrame(Name, 0);
		
		for(var i = 0; i < 15; ++i) {
			QueuePersonCommand(Name, COMMAND_ANIMATE, false);
			QueuePersonCommand("t", COMMAND_ANIMATE, false);
		}
		
		WaitForPerson(Name);
		DestroyPerson("t");
		SetPersonDirection(Name, "north");
		SetPersonFrame(Name, 0);
		UpdateMapEngine();
		TeleportMe = false;
		TileMovement.unpauseEngine();
		On_Enter();
	}
}

function WaitForPerson(who)
{
	SetFrameRate(GameSpeed);
	while(!IsCommandQueueEmpty(who)) {
		UpdateMapEngine();
		RenderMap();
		FlipScreen();
	}
	SetFrameRate(0);
}